
# Example for an graphical evaluation of regressions in an R Execute Container in Azure ML
#
# using ggplot2 and various ggplot functions
#
# (c) Mario Schnalzenberger (cubido)


# Map 1-based optional input ports to variables
dataset1 <- maml.mapInputPort(1) # class: data.frame
#dataset2 <- maml.mapInputPort(2) # class: data.frame

library(ggplot2);
library(Hmisc)
#library(plyr);

# Contents of optional Zip port are in ./src/
# source("src/yourfile.R");
# load("src/yourData.rdata");

# Sample operation


names(dataset1)[names(dataset1)=="Scored Labels"] <- "Vorhersage";
names(dataset1)[names(dataset1)=="Scored Label Mean"] <- "Vorhersage";
#names(dataset2)[names(dataset2)=="Scored Labels"] <- "Vorhersage";

names(dataset1);

# Save ggplot function to variable for reuse
g <- ggplot(dataset1, aes(y = Vorhersage, x = TargetValue, color=PositionA))

# Use in combination
g + geom_point(shape=1) + geom_smooth(method=lm,   # Add linear regression lines
                                      se=FALSE,    # Don't add shaded confidence region
                                      fullrange=TRUE, color="black") + geom_abline(intercept = 0, slope = 1, color="black", linetype="dashed")

# group real values in bins
dataset1$wt2 <- as.numeric(cut2(dataset1$TargetValue, g=10))

# Save ggplot function to variable for reuse
g <- ggplot(dataset1, aes(factor(wt2), Vorhersage, color=PositionA))

# Use in combination of violin and scatter
g + geom_point() + geom_violin(color="black")

# calculate correlations
cor(dataset1$TargetValue, dataset1$Vorhersage)
